﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Workflow.Runtime;
using System.Workflow.Activities;
using System.Workflow.Runtime.Hosting;
using System.Threading;



/*  Scheduling services 
 
    This example uses two WorkflowRuntime objects. The workflowRuntime2 uses a 
    ManualWorkflowSchedulerService scheduling service.
 
 */
namespace Lessons.Workflows
{
    public partial class MainForm : Form
    {
        public MainForm()
        {
            InitializeComponent();
        }

        delegate void InfoDelegate(string Text);
        private delegate void WorkflowDoneDelegate();

        WorkflowRuntime workflowRuntime = null;
        WorkflowRuntime workflowRuntime2 = null;
        WorkflowInstance instance = null;

        ManualWorkflowSchedulerService scheduler; 

        /* adds the Text to the ListBox in a synchronized manner */
        public void ProcessInfo(string Text)
        {
            if (this.InvokeRequired)
            {
                /* if synchronization is required, then re-call itself through an invoked delegate */
                InfoDelegate d = delegate(string s) { ProcessInfo(s); };
                this.Invoke(d, Text);
            }
            else
            {
                this.lboInfo.Items.Add(Text);
            }  
        }

        /* arrange the user interface upon workflow termination, in a synchronized manner */
        private void WorkflowDone()
        {
            if (this.InvokeRequired)
            {
                WorkflowDoneDelegate d = delegate() { WorkflowDone(); };
                this.Invoke(d);
            }
            else
            {
                btnStartWorkflow.Enabled = true;
                lboInfo.Items.Add("-----------");
            }
        }
        
 

        private void MainForm_Load(object sender, EventArgs e)
        { 
            workflowRuntime = new WorkflowRuntime();
 
            workflowRuntime.WorkflowCompleted += new EventHandler<WorkflowCompletedEventArgs>(WorkflowCompleted);
            workflowRuntime.WorkflowTerminated += new EventHandler<WorkflowTerminatedEventArgs>(WorkflowTerminated);
 
            ExternalDataExchangeService ExchangeService = new ExternalDataExchangeService();
            workflowRuntime.AddService(ExchangeService);
            WorkflowInfo workflowInfo = new WorkflowInfo(this);
            ExchangeService.AddService(workflowInfo);




            /* initialization code for the second WorkflowRuntime */
            workflowRuntime2 = new WorkflowRuntime();

            workflowRuntime2.WorkflowCompleted += new EventHandler<WorkflowCompletedEventArgs>(WorkflowCompleted);
            workflowRuntime2.WorkflowTerminated += new EventHandler<WorkflowTerminatedEventArgs>(WorkflowTerminated);

            ExternalDataExchangeService ExchangeService2 = new ExternalDataExchangeService();
            workflowRuntime2.AddService(ExchangeService2);
            WorkflowInfo workflowInfo2 = new WorkflowInfo(this);
            ExchangeService2.AddService(workflowInfo2);


            /* create the ManualWorkflowSchedulerService and add it to the runtime */
            scheduler = new ManualWorkflowSchedulerService();
            workflowRuntime2.AddService(scheduler);

            lboInfo.Items.Add("GUI ThreadID: " + Thread.CurrentThread.ManagedThreadId.ToString());
            lboInfo.Items.Add("-----------");
        }

        void WorkflowCompleted(object sender, WorkflowCompletedEventArgs e)
        {
            WorkflowDone();
        }

        void WorkflowTerminated(object sender, WorkflowTerminatedEventArgs e)
        {
            WorkflowDone();
        }



        private void btnStartWorkflow_Click(object sender, EventArgs e)
        {
            btnStartWorkflow.Enabled = false;
            

            if (chManualScheduler.Checked)
            {
                instance = workflowRuntime2.CreateWorkflow(typeof(Lessons.Workflows.Workflow1));
                instance.Start();
                scheduler.RunWorkflow(instance.InstanceId);
            }
            else
            {
                instance = workflowRuntime.CreateWorkflow(typeof(Lessons.Workflows.Workflow1));
                instance.Start();
            }

        }


        private void MainForm_FormClosed(object sender, FormClosedEventArgs e)
        {
            workflowRuntime.Dispose();
            workflowRuntime2.Dispose();
        }


    }
}





namespace Lessons.Workflows
{

    /* a class implementing the contract interface. Only one implementation is allowed */
    public class WorkflowInfo : IWorkflowInfo
    {
        MainForm form;

        public WorkflowInfo(MainForm Form)
        {
            form = Form;
        }

        public void InformHost(string Text)
        {
            string S = " - ThreadID: " + Thread.CurrentThread.ManagedThreadId.ToString();
            form.ProcessInfo(Text + S);
        }
    }

}